/*
 * Decompiled with CFR 0.152.
 */
package com.alcatrazescapee.primalwinter.util;

import com.alcatrazescapee.primalwinter.networking.NetworkHandler;
import com.alcatrazescapee.primalwinter.networking.packet.WeatherPacket;
import com.mojang.logging.LogUtils;
import java.util.Random;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.slf4j.Logger;

@Mod.EventBusSubscriber(modid="primalwinter", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class TickEventHandler {
    private static boolean raining = false;
    private static final Logger LOGGER = LogUtils.getLogger();
    private static Random random = new Random();

    @SubscribeEvent
    public static void onLevelTick(TickEvent.LevelTickEvent event) {
        if (event.level.f_46443_) {
            return;
        }
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        if (event.level.m_46472_() != Level.f_46428_) {
            return;
        }
        if (event.level.m_46471_()) {
            if (!raining) {
                int randomNumber = random.nextInt(10) + 1;
                float fogDensity = 0.0f;
                int snowDensity = 0;
                boolean windsounds = false;
                boolean weatherRenderChanges = false;
                if (randomNumber > 8) {
                    fogDensity = 0.1f + random.nextFloat() * 0.4f;
                    snowDensity = 15;
                    windsounds = true;
                    weatherRenderChanges = true;
                    LOGGER.info("Blizzard");
                } else if (randomNumber > 4) {
                    fogDensity = 0.45f + random.nextFloat() * 0.19999999f;
                    snowDensity = random.nextInt(10, 15);
                    weatherRenderChanges = true;
                    LOGGER.info("Heavy Snowfall");
                } else {
                    fogDensity = 0.5f + random.nextFloat() * 0.5f;
                    snowDensity = random.nextInt(5, 10);
                    LOGGER.info("Light Snowfall");
                }
                LOGGER.info("fog density: " + fogDensity);
                LOGGER.info("snow density: " + snowDensity);
                LOGGER.info("windsounds: " + windsounds);
                LOGGER.info("weather render changes: " + weatherRenderChanges);
                NetworkHandler.sendToAll(new WeatherPacket(fogDensity, snowDensity, windsounds, weatherRenderChanges));
            }
            raining = true;
        } else {
            raining = false;
        }
    }
}

